//
//  OPLocalization.h
//  OnePasswordiOS
//
//  Created by Roustem Karimov on 2012-12-15.
//  Copyright (c) 2012 AgileBits. All rights reserved.
//
//  Based on: http://aggressive-mediocrity.blogspot.ca/2010/03/custom-localization-system-for-your.html
//

#import <Foundation/Foundation.h>

extern NSString *OPPrefLanguage;

@interface OPLocalization : NSObject

@property (nonatomic, copy) NSString * language;

+ (instancetype)sharedLocalization;

- (NSString *)localizedStringForKey:(NSString *)key;
- (NSString *)localizedStringForKey:(NSString *)key table:(NSString *)table;
- (NSArray *)availableLanguages;

- (void)resetLocalization;

@end

static inline NSString * OPLocalizedString(NSString *key, NSString *comment) {
	return [[OPLocalization sharedLocalization] localizedStringForKey:key];
}



